document.addEventListener("DOMContentLoaded", () => {
    const draggables = document.querySelectorAll(".draggable");
    const dropZones = document.querySelectorAll(".drop-zone");
    const verifyButton = document.getElementById("verify-button");
    const replayButton = document.getElementById("replay-button");
    const resultMessage = document.getElementById("result-message");

    // Permettre le drag des éléments
    draggables.forEach(draggable => {
        draggable.addEventListener("dragstart", (e) => {
            if (!draggable.classList.contains("used")) {
                e.dataTransfer.setData("text/plain", draggable.id);
            } else {
                e.preventDefault();
            }
        });
    });

    // Permettre le drop dans toutes les zones
    dropZones.forEach(zone => {
        zone.addEventListener("dragover", (e) => {
            e.preventDefault();
        });

        zone.addEventListener("drop", (e) => {
            e.preventDefault();
            const draggedId = e.dataTransfer.getData("text/plain");
            const draggedElement = document.getElementById(draggedId);

            if (draggedElement && !draggedElement.classList.contains("used")) {
                zone.innerHTML = draggedElement.innerHTML;
                zone.setAttribute("data-placed", draggedId); // Sauvegarde l'élément placé
                draggedElement.classList.add("used"); // Désactiver le mot après placement
                draggedElement.style.opacity = "0.5"; // Rendre le mot grisé
                draggedElement.draggable = false;
            }
        });
    });

    // Vérification des placements
    verifyButton.addEventListener("click", () => {
        let allCorrect = true;

        dropZones.forEach(zone => {
            const expected = zone.dataset.component; // Composant attendu
            const placed = zone.getAttribute("data-placed"); // Composant placé

            if (expected !== placed) {
                allCorrect = false;
                zone.style.border = "2px solid red"; // Indiquer l'erreur
            } else {
                zone.style.border = "2px solid green"; // Indiquer que c'est correct
            }
        });

        if (allCorrect) {
            resultMessage.textContent = "Bravo ! Tous les composants sont bien placés 🎉";
            resultMessage.style.color = "green";
        } else {
            resultMessage.textContent = "Il y a encore des erreurs, réessayez ! ❌";
            resultMessage.style.color = "red";
        }
        replayButton.style.display = "block"; // Afficher le bouton rejouer
    });

    // Rejouer : réinitialise tout
    replayButton.addEventListener("click", () => {
        dropZones.forEach(zone => {
            zone.innerHTML = "";
            zone.style.border = "2px solid black"; // Réinitialiser les bordures
            zone.removeAttribute("data-placed");
        });

        draggables.forEach(draggable => {
            draggable.classList.remove("used");
            draggable.style.opacity = "1"; // Rendre les mots visibles
            draggable.draggable = true;
        });

        resultMessage.textContent = "";
        replayButton.style.display = "none"; // Cacher le bouton rejouer
    });
});
