document.addEventListener("DOMContentLoaded", () => {
    console.log("Jeu de phrases à trous chargé !");
    generateWordList();
});

const answers = {
    1: "processeur",
    2: "périphérique",
    3: "disque dur",
    4: "JavaScript",
    5: "navigateur",
    6: "bus",
    7: "applications",
    8: "imprimante",
    9: "internet",
    10: "graphique"
};

// Fonction pour générer la liste des mots à deviner de manière aléatoire
function generateWordList() {
    const wordListElement = document.getElementById("wordList");
    const wordArray = Object.values(answers);
    shuffleArray(wordArray); // Mélange les mots

    // Ajoute les mots mélangés à la liste
    wordArray.forEach(word => {
        const listItem = document.createElement("li");
        listItem.textContent = word;
        wordListElement.appendChild(listItem);
    });
}

// Fonction pour mélanger un tableau
function shuffleArray(array) {
    for (let i = array.length - 1; i > 0; i--) {
        const j = Math.floor(Math.random() * (i + 1));
        [array[i], array[j]] = [array[j], array[i]];
    }
}

function checkAnswers() {
    let score = 0;

    // Vérification des réponses
    for (let i = 1; i <= 10; i++) {
        const userAnswer = document.getElementById(`blank-${i}`).textContent.trim().toLowerCase();
        if (userAnswer === answers[i].toLowerCase()) {
            score++;
            document.getElementById(`blank-${i}`).style.backgroundColor = "lightgreen";
        } else {
            document.getElementById(`blank-${i}`).style.backgroundColor = "salmon";
        }
    }

    // Affichage du résultat
    const resultText = `Vous avez obtenu ${score} sur 10 !`;
    document.getElementById("result").textContent = resultText;
}
